/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.ui.wizard.exe;

import com.aptana.php.debug.epl.PHPDebugEPLPlugin;
import com.aptana.php.debug.ui.phpini.PHPIniEditor;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org2.eclipse.php.internal.debug.core.interpreter.preferences.PHPexeItem;
import org2.eclipse.php.internal.debug.core.preferences.PHPDebuggersRegistry;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIImages;
import org2.eclipse.php.internal.debug.ui.PHPDebugUIMessages;
import org2.eclipse.php.internal.debug.ui.wizard.CompositeFragment;
import org2.eclipse.php.internal.debug.ui.wizard.IControlHandler;
import org2.eclipse.php.internal.debug.ui.wizard.exe.IPHPExeCompositeFragment;
import org2.eclipse.php.internal.debug.ui.wizard.exe.PHPExeEditDialog;
import org2.eclipse.php.internal.ui.util.PixelConverter;
import org2.eclipse.php.internal.ui.wizard.field.DialogField;
import org2.eclipse.php.internal.ui.wizard.field.IDialogFieldListener;
import org2.eclipse.php.internal.ui.wizard.field.IStringButtonAdapter;
import org2.eclipse.php.internal.ui.wizard.field.StringButtonDialogField;
import org2.eclipse.php.internal.ui.wizard.field.StringDialogField;

public class PHPExeCompositeFragment
extends CompositeFragment
implements IPHPExeCompositeFragment {
    private static final String[] EXTENSIONS_FILTERS = new String[]{"*.ini", "*.*"};
    private static final String PHP_INI = "php.ini";
    private PHPexeItem[] existingItems;
    private StringDialogField fPHPexeName;
    private StringButtonDialogField fPHPExePath;
    private StringButtonDialogField fPHPIni;
    private List<String> debuggersIds;
    private Label fDebuggersLabel;
    private Combo fDebuggers;
    private String initialName;
    private PHPIniEditor iniEditor;
    private boolean needValidation;

    public PHPExeCompositeFragment(Composite parent, IControlHandler handler, boolean isForEditing) {
        super(parent, handler, isForEditing);
        this.setDescription(PHPDebugUIMessages.PHPExeCompositeFragment_description);
        this.setDisplayName(PHPDebugUIMessages.PHPExeCompositeFragment_displayName);
        this.controlHandler.setDescription(this.getDescription());
        this.controlHandler.setImageDescriptor(PHPDebugUIImages.getImageDescriptor("IMG_WIZBAN_PHPEXE"));
        this.debuggersIds = new LinkedList<String>(PHPDebuggersRegistry.getDebuggersIds());
        this.createControl();
        if (handler instanceof PHPExeEditDialog && this.iniEditor != null) {
            this.needValidation = ((PHPExeEditDialog)handler).shouldValidate();
        }
    }

    @Override
    public void setExistingItems(PHPexeItem[] existingItems) {
        this.existingItems = existingItems;
    }

    @Override
    public void setData(Object data) {
        if (data != null && !(data instanceof PHPexeItem)) {
            throw new IllegalArgumentException("Data must be instance of PHPExeItem");
        }
        super.setData(data);
        this.init();
    }

    public PHPexeItem getPHPExeItem() {
        return (PHPexeItem)super.getData();
    }

    protected String getPHPexeName() {
        return this.fPHPexeName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fPHPExePath.getText());
    }

    protected File getIniLocation() {
        return new File(this.fPHPIni.getText());
    }

    protected void createControl() {
        PixelConverter pixelConverter = new PixelConverter((Control)this);
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Composite parent = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1808));
        this.fPHPexeName = new StringDialogField();
        this.fPHPexeName.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpName);
        this.fPHPExePath = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                FileDialog dialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                dialog.setFilterPath(PHPExeCompositeFragment.this.fPHPExePath.getText());
                dialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPRootDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    PHPExeCompositeFragment.this.fPHPExePath.setText(newPath);
                    PHPExeCompositeFragment.this.iniEditor.setPHPExe(newPath);
                }
            }
        });
        this.fPHPExePath.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpHome);
        this.fPHPExePath.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPIni = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                FileDialog dialog = new FileDialog(PHPExeCompositeFragment.this.getShell());
                dialog.setFilterPath(PHPExeCompositeFragment.this.fPHPIni.getText());
                dialog.setFilterExtensions(EXTENSIONS_FILTERS);
                dialog.setText(PHPDebugUIMessages.addPHPexeDialog_pickPHPIniDialog_message);
                String newPath = dialog.open();
                if (newPath != null) {
                    PHPExeCompositeFragment.this.fPHPIni.setText(newPath);
                    if (newPath != null && !"".equals(newPath)) {
                        try {
                            PHPExeCompositeFragment.this.iniEditor.openFile(newPath);
                        }
                        catch (IOException e) {
                            String message = MessageFormat.format(PHPDebugUIMessages.PHPExeCompositeFragment_errorOpening, PHPExeCompositeFragment.this.iniEditor.getFileName());
                            if (PHPExeCompositeFragment.this.isPermissionProblem(e)) {
                                message = String.valueOf(message) + PHPDebugUIMessages.PHPExeCompositeFragment_openErrorPermissionMessage;
                            }
                            PHPExeCompositeFragment.this.openError(PHPDebugUIMessages.PHPExeCompositeFragment_errorTitle, message, e);
                        }
                    }
                }
            }
        });
        this.fPHPIni.setLabelText(String.valueOf(PHPDebugUIMessages.addPHPexeDialog_phpIni) + PHPDebugUIMessages.addPHPexeDialog_optional);
        this.fPHPIni.setButtonLabel(PHPDebugUIMessages.addPHPexeDialog_browse1);
        this.fPHPexeName.doFillIntoGrid(parent, 3);
        this.fPHPExePath.doFillIntoGrid(parent, 3);
        ((GridData)this.fPHPExePath.getTextControl((Composite)parent).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fPHPIni.doFillIntoGrid(parent, 3);
        ((GridData)this.fPHPIni.getTextControl((Composite)parent).getLayoutData()).widthHint = pixelConverter.convertWidthInCharsToPixels(50);
        this.fDebuggersLabel = new Label(parent, 16448);
        this.fDebuggersLabel.setFont(parent.getFont());
        this.fDebuggersLabel.setText(PHPDebugUIMessages.addPHPexeDialog_phpDebugger);
        GridData data = new GridData();
        data.horizontalSpan = 1;
        this.fDebuggersLabel.setLayoutData((Object)data);
        this.fDebuggers = new Combo(parent, 12);
        data = new GridData();
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.fDebuggers.setLayoutData((Object)data);
        int i = 0;
        while (i < this.debuggersIds.size()) {
            String id = this.debuggersIds.get(i);
            String debuggerName = PHPDebuggersRegistry.getDebuggerName(id);
            this.fDebuggers.add(debuggerName, i);
            ++i;
        }
        this.fDebuggers.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int selectionIndex = PHPExeCompositeFragment.this.fDebuggers.getSelectionIndex();
                String debuggerID = (String)PHPExeCompositeFragment.this.debuggersIds.get(selectionIndex);
                PHPExeCompositeFragment.this.getPHPExeItem().setDebuggerID(debuggerID);
                PHPExeCompositeFragment.this.iniEditor.setDebuggerID(debuggerID);
            }
        });
        TabFolder settings = new TabFolder(parent, 0);
        TabItem iniEditorTab = new TabItem(settings, 0);
        iniEditorTab.setText(PHPDebugUIMessages.PHPExeCompositeFragment_iniEditorTabText);
        Composite iniEditorGroup = new Composite((Composite)settings, 0);
        iniEditorTab.setControl((Control)iniEditorGroup);
        GridData grdata = new GridData(4, 4, true, true, 3, 1);
        grdata.heightHint = 400;
        settings.setLayoutData((Object)grdata);
        GridLayout iniGroupLayout = new GridLayout();
        iniGroupLayout.marginWidth = 5;
        iniEditorGroup.setLayout((Layout)iniGroupLayout);
        this.iniEditor = new PHPIniEditor();
        Control iniEditorControl = this.iniEditor.createControl(iniEditorGroup);
        iniEditorControl.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        parent.layout();
        this.init();
        this.createFieldListeners();
        this.validate();
        Dialog.applyDialogFont((Control)this);
    }

    protected void createFieldListeners() {
        this.fPHPexeName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PHPExeCompositeFragment.this.validate();
            }
        });
        this.fPHPExePath.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PHPExeCompositeFragment.this.validate();
            }
        });
        this.fPHPIni.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                PHPExeCompositeFragment.this.validate();
            }
        });
    }

    protected void init() {
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem == null || phpExeItem.getName() == null) {
            this.fPHPexeName.setText("");
            this.fPHPExePath.setText("");
            this.fPHPIni.setText("");
            String defaultDebuggerId = PHPDebuggersRegistry.getDefaultDebuggerId();
            if (defaultDebuggerId != null) {
                int index = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName(defaultDebuggerId));
                this.fDebuggers.select(index);
            } else if (this.fDebuggers.getItemCount() > 0) {
                this.fDebuggers.select(0);
            } else {
                this.hideDebuggersCombo();
            }
            this.setTitle(PHPDebugUIMessages.PHPExeCompositeFragment_addInterpreterTitle);
        } else {
            this.initialName = phpExeItem.getName();
            this.fPHPexeName.setTextWithoutUpdate(phpExeItem.getName());
            this.fPHPexeName.setEnabled(phpExeItem.isEditable());
            File executable = phpExeItem.getExecutable();
            this.fPHPExePath.setTextWithoutUpdate(executable != null ? executable.getAbsolutePath() : "");
            this.fPHPExePath.setEnabled(phpExeItem.isEditable());
            this.iniEditor.setPHPExe(executable != null ? executable.getAbsolutePath() : "");
            if (phpExeItem.getINILocation() != null) {
                this.fPHPIni.setTextWithoutUpdate(phpExeItem.getINILocation().toString());
            }
            this.fPHPIni.setEnabled(phpExeItem.isEditable());
            if (this.fPHPIni.getText() != null && !"".equals(this.fPHPIni.getText())) {
                try {
                    this.iniEditor.openFile(this.fPHPIni.getText());
                }
                catch (IOException e) {
                    String message = MessageFormat.format(PHPDebugUIMessages.PHPExeCompositeFragment_errorOpening, this.iniEditor.getFileName());
                    if (this.isPermissionProblem(e)) {
                        message = String.valueOf(message) + PHPDebugUIMessages.PHPExeCompositeFragment_openErrorPermissionMessage;
                    }
                    this.openError(PHPDebugUIMessages.PHPExeCompositeFragment_errorTitle, message, e);
                }
            }
            String debuggerID = phpExeItem.getDebuggerID();
            this.fDebuggers.setEnabled(phpExeItem.isEditable());
            this.fDebuggersLabel.setEnabled(phpExeItem.isEditable());
            int index = this.fDebuggers.indexOf(PHPDebuggersRegistry.getDebuggerName(debuggerID));
            if (index > -1) {
                this.fDebuggers.select(index);
            } else if (this.fDebuggers.getItemCount() > 0) {
                this.fDebuggers.select(0);
            } else {
                this.hideDebuggersCombo();
            }
            this.iniEditor.setDebuggerID(debuggerID);
            this.setTitle(PHPDebugUIMessages.PHPExeCompositeFragment_editInterpreterTitle);
        }
        this.controlHandler.setTitle(this.getTitle());
        this.validate();
        if (this.needValidation) {
            this.needValidation = this.iniEditor.validateExtensions();
        }
    }

    private void hideDebuggersCombo() {
        this.fDebuggers.setVisible(false);
        this.fDebuggersLabel.setVisible(false);
    }

    protected void validate() {
        String locationName;
        PHPexeItem phpExeItem = this.getPHPExeItem();
        if (phpExeItem == null) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_readOnlyPHPExe, 1);
            return;
        }
        String name = this.fPHPexeName.getText();
        if (name == null || name.trim().length() == 0) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterName, 1);
            return;
        }
        if (this.existingItems != null) {
            PHPexeItem[] pHPexeItemArray = this.existingItems;
            int n = this.existingItems.length;
            int n2 = 0;
            while (n2 < n) {
                PHPexeItem item = pHPexeItemArray[n2];
                if (!item.getName().equals(this.initialName) && item.getName().equals(name)) {
                    this.setMessage(PHPDebugUIMessages.addPHPexeDialog_duplicateName, 3);
                    return;
                }
                ++n2;
            }
        }
        if ((locationName = this.fPHPExePath.getText()).length() == 0) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_enterLocation, 1);
            return;
        }
        File executableLocation = new File(locationName);
        if (!executableLocation.exists()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_locationNotExists, 3);
            return;
        }
        boolean iniOptional = new File(executableLocation.getParentFile(), PHP_INI).exists();
        if (iniOptional) {
            this.fPHPIni.setLabelText(String.valueOf(PHPDebugUIMessages.addPHPexeDialog_phpIni) + PHPDebugUIMessages.addPHPexeDialog_optional);
        } else {
            this.fPHPIni.setLabelText(PHPDebugUIMessages.addPHPexeDialog_phpIni);
        }
        String iniLocationName = this.fPHPIni.getText();
        File iniFile = null;
        if (iniLocationName.trim().length() == 0) {
            if (executableLocation.exists()) {
                iniFile = new File(executableLocation.getParentFile(), PHP_INI);
                iniLocationName = iniFile.getAbsolutePath();
            }
        } else {
            iniFile = new File(iniLocationName);
        }
        if (iniFile == null || !iniFile.exists()) {
            this.setMessage(PHPDebugUIMessages.addPHPexeDialog_iniLocationNotExists, 3);
            if (this.iniEditor != null) {
                this.iniEditor.disable();
            }
            return;
        }
        phpExeItem.setName(name);
        phpExeItem.setExecutable(executableLocation);
        if (phpExeItem.getExecutable() == null) {
            this.setMessage(PHPDebugUIMessages.PHPExeCompositeFragment_executableFatalError, 3);
            return;
        }
        phpExeItem.setDebuggerID(this.debuggersIds.get(this.fDebuggers.getSelectionIndex()));
        phpExeItem.setINILocation(iniFile);
        this.setMessage(this.getDescription(), 0);
        if (this.iniEditor != null) {
            if (iniLocationName.trim() != null && !"".equals(iniLocationName.trim())) {
                if (!iniLocationName.equals(this.iniEditor.getFileName())) {
                    try {
                        this.iniEditor.openFile(iniLocationName);
                    }
                    catch (IOException e) {
                        String message = MessageFormat.format(PHPDebugUIMessages.PHPExeCompositeFragment_errorOpening, iniLocationName);
                        if (this.isPermissionProblem(e)) {
                            message = String.valueOf(message) + PHPDebugUIMessages.PHPExeCompositeFragment_openErrorPermissionMessage;
                        }
                        this.openError(PHPDebugUIMessages.PHPExeCompositeFragment_errorTitle, message, e);
                    }
                }
            } else {
                this.iniEditor.disable();
            }
        }
        this.controlHandler.update();
    }

    protected void setMessage(String message, int type) {
        this.controlHandler.setMessage(message, type);
        this.setComplete(type == 0);
        this.controlHandler.update();
    }

    @Override
    public boolean performOk() {
        try {
            this.iniEditor.save();
        }
        catch (IOException e) {
            String message = MessageFormat.format(PHPDebugUIMessages.PHPExeCompositeFragment_errorSaving, this.iniEditor.getFileName());
            if (this.isPermissionProblem(e)) {
                message = String.valueOf(message) + PHPDebugUIMessages.PHPExeCompositeFragment_saveErrorPermissionMessage;
            }
            this.openError(PHPDebugUIMessages.PHPExeCompositeFragment_saveErrorTitle, message, e);
        }
        return true;
    }

    private void openError(final String title, final String error, final Throwable t) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPDebugEPLPlugin.logError(error, t);
                Display display = Display.getDefault();
                Shell activeShell = display.getActiveShell();
                MessageDialog.openError((Shell)activeShell, (String)title, (String)error);
            }
        });
    }

    private boolean isPermissionProblem(Throwable t) {
        return t instanceof FileNotFoundException && t.getMessage() != null && t.getMessage().toLowerCase().contains("permission");
    }
}

